struct VS_INPUT // FVF 322
{
    float4 Position   : POSITION;
	float4 Diffuse	  : COLOR;
    float2 TexCoord   : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position 	: POSITION;
    float2 TexCoord0	: TEXCOORD0;
    float3 TexCoord1	: TEXCOORD1; // u,v, distance from center
	float  ViewDepth	: TEXCOORD2;
	float4 WorldPos		: TEXCOORD3;
	float4 Diffuse		: COLOR;
};

sampler2D Tex0 : register( s0 );
sampler2D Tex1 : register( s1 );

samplerCUBE TexEnv : register( s4 );

float4x4 TexTx0 : TEXTX0;
float4x4 TexTx1 : TEXTX1;

float4x4 World : WORLD;
float4x4 View : VIEW;
float4x4 ViewProj : VIEWPROJ;

#define WorldSpaceLight
#include "Light.fx"
#include "Fog.fx"

VS_OUTPUT vs_main(uniform bool bNeedTC1, in VS_INPUT In)
{
    VS_OUTPUT Out;
	float4 posWorld = mul(In.Position, World);
    Out.Position = mul(posWorld, ViewProj); // position in clip space
	Out.WorldPos = posWorld; // position in world space
	Out.ViewDepth = mul(posWorld, View).z; // depth of position in view space
	Out.TexCoord0 = mul(float3(In.TexCoord,1), (float3x3)TexTx0).xy;
	if(bNeedTC1)
	{
		Out.TexCoord1.xy = mul(float3(In.TexCoord,1), (float3x3)TexTx1).xy;
		Out.TexCoord1.z = saturate(1 - (length(Out.TexCoord1.xy - float2(0.5,0.5)) - 0.45) * 10);
	}
	else
	{
		Out.TexCoord1 = 0;
	}
	Out.Diffuse = In.Diffuse;
	return Out;
}
/*
float4x4 ViewProjLight;
sampler2D TexShadow : register( s15 );

float4 calcShadowPos(float4 WorldPos, float2 ShadowTexC, float4 vPosLight)
{
	ShadowTexC.y = 1.0 - ShadowTexC.y;
	return float4(ShadowTexC.xy, vPosLight.z/vPosLight.w, 0.0);
}

float calcLightAmount(float4 WorldPos)
{
	const float Half = 0.5;
	float4 vPosLight = mul(WorldPos, ViewProjLight);
	float2 ShadowTexC = Half * vPosLight.xy / vPosLight.w + Half.xx;
	float4 samplePos = calcShadowPos(WorldPos, ShadowTexC, vPosLight);
	if(samplePos.x < 0 || samplePos.y < 0 || samplePos.x > 1 || samplePos.x > 1) return 1;
	return tex2Dlod( TexShadow, samplePos ).x;
}
*/

void AddLight(in VS_OUTPUT In, inout float4 Color) 
{
	Color.rgb *= saturate(Sun.vDiffuse * saturate(In.Diffuse.rgb - 0.2) * 1.2 + vAmbientLight * 0.8);
}

float4 ps_main(in VS_OUTPUT In) : COLOR
{
	float4 Color;
	Color = tex2D( Tex0, In.TexCoord0 );
	AddLight(In, Color);
	ApplyFog(Color, CalcFog(In.ViewDepth));
	return Color;
}

float4 ps_blend(in VS_OUTPUT In) : COLOR
{
	float4 Color;
	Color = tex2D( Tex0, In.TexCoord0 );
	AddLight(In, Color);
	Color *= tex2D( Tex1, In.TexCoord1.xy ); // it is better with texture here
	ApplyFog(Color, CalcFog(In.ViewDepth));
	return Color;
}

float4 ps_details(in VS_OUTPUT In) : COLOR
{
	float4 Color;
	Color = tex2D( Tex0, In.TexCoord0 );
	Color.a = In.TexCoord1.z; // ok to use vertex distance
	return Color;
}

technique Terrain
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main(false);
		PixelShader = compile ps_3_0 ps_main();
	}
}

technique Alpha
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main(true);
		PixelShader = compile ps_3_0 ps_blend();
	}
}

technique Details
{
	pass Pass1
	{
		VertexShader = compile vs_3_0 vs_main(true);
		PixelShader = compile ps_3_0 ps_details();
	}
}